/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.trender.gui.client;

import dev.tr7zw.trender.gui.client.RenderContext;
import dev.tr7zw.trender.gui.widget.WWidget;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1041;
import net.minecraft.class_310;

public final class CottonHud {
    private static final Set<WWidget> widgets = new HashSet<WWidget>();
    private static final Map<WWidget, Positioner> positioners = new HashMap<WWidget, Positioner>();

    public static void add(WWidget widget) {
        widgets.add(widget);
    }

    public static void add(WWidget widget, int x, int y) {
        CottonHud.add(widget, Positioner.of(x, y));
    }

    public static void add(WWidget widget, int x, int y, int width, int height) {
        CottonHud.add(widget, Positioner.of(x, y));
        widget.setSize(width, height);
    }

    public static void add(WWidget widget, Positioner positioner) {
        widgets.add(widget);
        CottonHud.setPositioner(widget, positioner);
    }

    public static void add(WWidget widget, Positioner positioner, int width, int height) {
        widgets.add(widget);
        widget.setSize(width, height);
        CottonHud.setPositioner(widget, positioner);
    }

    public static void setPositioner(WWidget widget, Positioner positioner) {
        positioners.put(widget, positioner);
    }

    public static void remove(WWidget widget) {
        widgets.remove(widget);
    }

    static {
        HudRenderCallback.EVENT.register((drawContext, tickDelta) -> {
            class_1041 window = class_310.method_1551().method_22683();
            int hudWidth = window.method_4486();
            int hudHeight = window.method_4502();
            RenderContext renderContext = new RenderContext(drawContext);
            for (WWidget widget : widgets) {
                Positioner positioner = positioners.get(widget);
                if (positioner != null) {
                    positioner.reposition(widget, hudWidth, hudHeight);
                }
                widget.paint(renderContext, widget.getX(), widget.getY(), -1, -1);
            }
        });
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            for (WWidget widget : widgets) {
                widget.tick();
            }
        });
    }

    @FunctionalInterface
    public static interface Positioner {
        public void reposition(WWidget var1, int var2, int var3);

        public static Positioner of(int x, int y) {
            return (widget, hudWidth, hudHeight) -> widget.setLocation((hudWidth + x) % hudWidth, (hudHeight + y) % hudHeight);
        }

        public static Positioner horizontallyCentered(int y) {
            return (widget, hudWidth, hudHeight) -> widget.setLocation((hudWidth - widget.getWidth()) / 2, (hudHeight + y) % hudHeight);
        }
    }
}

